model:setName( "Film_Type_Nostalgic" )
model:caption( "Film Type Nostalgic" )

model:addSource("inputImage")
model:addSource("originalImage")
model:addSource("histogram0")
model:addSource("histogram1")
model:addSource("histogram2")
model:addSource("histogram3")
model:addSource("histogram4")
model:addSource("histogram5")

--basis filter added
f1= model:addFilter("LscAndSinterFilter")
f2= model:addFilter("ClassicalSoftFocus")
f3= model:addFilter( "VignetteFilter" )
f4= model:addFilter("GrainFilter")
f5= model:addFilter("LevelsAndCurvesFilter")	-- Film Characteristics


------------- Curve Definition ------------------

curve_neutral = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0.03"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="0.98"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="0"/>
<key name="intNodeX0" value="0"/><key name="intNodeY0" value="0"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_g = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="2"/>
<key name="intNodeX0" value="0.2"/><key name="intNodeY0" value="0.13"/><key name="intNodeX1" value="0.8"/><key name="intNodeY1" value="0.87"/><key name="intNodeX2" value="0.5"/><key name="intNodeY2" value="0.42"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_b = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="0.8"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="0"/>
<key name="intNodeX0" value="0.1"/><key name="intNodeY0" value="0.13"/><key name="intNodeX1" value="0.8"/><key name="intNodeY1" value="0.87"/><key name="intNodeX2" value="0.5"/><key name="intNodeY2" value="0.42"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]




--lscValues--------------------------------------
lsc = model:getFilter(f1)
lsc:setIntParameter( "sinterStrucLscMode0_", 1  )
lsc:setIntParameter( "sinterStrucLscMode1_" ,1 )
lsc:setIntParameter( "tileSizeLevel0", 2 )
lsc:setIntParameter( "tileSizeLevel1", 2 )
lsc:setIntParameter( "selectedChannel0_", 1 )
lsc:setIntParameter( "selectedChannel1_", 2 )
lsc:setFloatParameter( "sigma20", 40 )
lsc:setFloatParameter( "sigma21", 40 )
lsc:setIntParameter("lemmingType0", 0 )
lsc:setIntParameter( "lemmingType1",0 )
lsc:setFloatParameter("maxDeriv0", 8)
lsc:setFloatParameter( "maxDeriv1", 8 )
lsc:setFloatParameter( "strength0", 100 )
lsc:setFloatParameter( "strength1", 100 )
lsc:setFloatParameter( "strengthFactor", 100 )
lsc:setFloatParameter( "totalStrength", 100 )
lsc:setFloatParameter( "brightness", 0)
lsc:setFloatParameter( "contrast", 0 )
lsc:setFloatParameter( "saturation", -25)
lsc:setFloatParameter( "csStrength", 0.0 )
lsc:setFloatParameter( "deltaT", 0 )  -- aus
lsc:setFloatParameter( "numberOfTimesteps", 2)
lsc:setFloatParameter( "modifier_A", 0.75)
lsc:setFloatParameter( "modifier_B", 48)
lsc:setFloatParameter( "modifier_C",3)
lsc:setFloatParameter( "modifier_D", 75)


--model:forwardFloatParameter("csStrength", f1, "csStrength", 0, 0, 1, "csStrength", "" ) 
--model:forwardFloatParameter("saturation", f1, "saturation", -20, -40, 30, "Saturation", "" )

--Classical Soft Focus Values
filter2 = model:getFilter(f2)
filter2:setIntParameter( "method", 2 )
filter2:setFloatParameter( "diffuse", 0.5 )
model:forwardFloatParameter("brightness", f2, "brightness", 0.25, -0.50, 0.75, "Brightness", "" )

model:forwardFloatParameter("totalStrength", f1, "totalStrength", 80, 0, 100, "Perceptual Saturation", "" )

model:forwardFloatParameter("diffuseStrength", f2, "strength", 0.40, 0.00, 1.00, "Glow", "" )

--vignette effect
filter3 = model:getFilter(f3)
model:forwardFloatParameterUiRangeAdapted( "vigStrength", f3, "vigStrength",  10, 0, 50, 0, 100, "Vignette", "")
filter3:setFloatParameter( "vigSize", 60 )


--grain effect
filter4 = model:getFilter(f4)
filter4:setFloatParameter( "grainSliderStrength", 450 )
model:forwardFloatParameter("grainSliderStrength", f4, "grainSliderStrength", 450, 1, 500, "Grain per pixel", "" )



--actual film curve
filter5 = model:getFilter(f5)
filter5:setLacData( "lacdataRGB", curve_neutral )
filter5:setLacData( "lacdataR", curve_neutral )
filter5:setLacData( "lacdataG", curve_g )
filter5:setLacData( "lacdataB", curve_b )
filter5:setLacData( "lacdataSmartBrightness", curve_neutral )
model:forwardFloatParameter( "strength_f5", f5, "strength", 80, 0, 100, "Film Strength", "")



---All Values are either zero or one //DEFAULT
default_Nostal  =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalR_4 =[[<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.927778"/>
	<key name="intNodeY0" value="0.977778"/>
	<key name="intNodeX1" value="0.672222"/>
	<key name="intNodeY1" value="0.8"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalG_4 =[[<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.927778"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.777778"/>
	<key name="intNodeY0" value="0.850299"/>
	<key name="intNodeX1" value="0.116667"/>
	<key name="intNodeY1" value="0.0658682"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalB_4 =[[<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.0555556"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.577778"/>
	<key name="gamma" value="0"/><key name="intNodeCount" value="0"/><key name="intNodeX0" value="0"/><key name="intNodeY0" value="0"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalSmart_4 = [[<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.916667"/>
	<key name="intNodeY0" value="0.972222"/>
	<key name="intNodeX1" value="0.566667"/>
	<key name="intNodeY1" value="0.705556"/>
	<key name="intNodeX2" value="0.05"/>
	<key name="intNodeY2" value="0.0166667"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/>	<key name="intNodeY4" value="0"/>	<key name="intNodeX5" value="0"/>	<key name="intNodeY5" value="0"/>	<key name="intNodeX6" value="0"/>	<key name="intNodeY6" value="0"/>	<key name="intNodeX7" value="0"/>	<key name="intNodeY7" value="0"/>	<key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

CurveNostalR_1= [[
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.233333"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.172222"/>
	<key name="intNodeY0" value="0.115942"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
CurveNostalG_1= [[
	<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.838889"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
CurveNostalB_1= [[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.333333"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.844444"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.533333"/>
	<key name="intNodeY0" value="0.366667"/>
	<key name="intNodeX1" value="0.555556"/>
	<key name="intNodeY1" value="0.408333"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalRGB_3 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.711111"/>
	<key name="intNodeY0" value="0.811111"/>
	<key name="intNodeX1" value="0.2"/>
	<key name="intNodeY1" value="0.155556"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
curveNostalR_3 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.605556"/>
	<key name="intNodeY0" value="0.516667"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
curveNostalG_3 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.3"/>
	<key name="intNodeY0" value="0.160377"/>
	<key name="intNodeX1" value="0.627778"/>
	<key name="intNodeY1" value="0.555556"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
curveNostalRGB_2 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
curveNostalR_2 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.233333"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.172222"/>
	<key name="intNodeY0" value="0.115942"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
curveNostalG_2 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.888889"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.355556"/>
	<key name="intNodeY0" value="0.29375"/>
	<key name="intNodeX1" value="0.538889"/>
	<key name="intNodeY1" value="0.668874
	<key name="intNodeX2" value="0/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]

curveNostalB_2 =[[
<Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.177778"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.844444"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.533333"/>
	<key name="intNodeY0" value="0.366667"/>
	<key name="intNodeX1" value="0.555556"/>
	<key name="intNodeY1" value="0.408333"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
]]
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 5
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
 valueRGB_5 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_5 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.405556"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.233333"/>
	<key name="intNodeY0" value="0.0373824"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_5 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.844444"/>
	<key name="intNodeY0" value="0.955556"/>
	<key name="intNodeX1" value="0.622222"/>
	<key name="intNodeY1" value="0.755556"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_5 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_5 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]

 
 -----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 6
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------

 valueRGB_6 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_6 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.494444"/>
	<key name="intNodeY0" value="0.333333"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_6 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.811111"/>
	<key name="intNodeY0" value="0.888889"/>
	<key name="intNodeX1" value="0.327778"/>
	<key name="intNodeY1" value="0.227778"/>
	<key name="intNodeX2" value="0.605556"/>
	<key name="intNodeY2" value="0.616667"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_6 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.755556"/>
	<key name="intNodeY0" value="0.855556"/>
	<key name="intNodeX1" value="0.322222"/>
	<key name="intNodeY1" value="0.422222"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_6 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 -----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 7
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
 valueRGB_7 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_7 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.244444"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_7 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_7 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0.272222"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_7 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 -----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 8
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
valueRGB_8 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_8 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_8 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.833333"/>
	<key name="intNodeY0" value="0.916667"/>
	<key name="intNodeX1" value="0.188889"/>
	<key name="intNodeY1" value="0.0833333"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_8 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_8 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 -----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 9
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------

valueRGB_9 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_9 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.0944444"/>
	<key name="intNodeY0" value="0.255556"/>
	<key name="intNodeX1" value="0.422222"/>
	<key name="intNodeY1" value="0.722222"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_9 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.833333"/>
	<key name="intNodeY0" value="0.916667"/>
	<key name="intNodeX1" value="0.316667"/>
	<key name="intNodeY1" value="0.45"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_9 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.316667"/>
	<key name="intNodeY0" value="0.344444"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_9 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 -----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 10
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
valueRGB_10 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_10 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.594444"/>
	<key name="intNodeY0" value="0.766667"/>
	<key name="intNodeX1" value="0.255556"/>
	<key name="intNodeY1" value="0.172222"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_10 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.855556"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.4"/>
	<key name="intNodeY0" value="0.514286"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_10 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="0.694444"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.488889"/>
	<key name="intNodeY0" value="0.56"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_10 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]

-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 11
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
valueRGB_11 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_11 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.594444"/>
	<key name="intNodeY0" value="0.75"/>
	<key name="intNodeX1" value="0.305556"/>
	<key name="intNodeY1" value="0.261111"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_11 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.822222"/>
	<key name="intNodeY0" value="0.938889"/>
	<key name="intNodeX1" value="0.222222"/>
	<key name="intNodeY1" value="0.155556"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_11 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.627778"/>
	<key name="intNodeY0" value="0.722222"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_11 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- CURVE 12
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
valueRGB_12 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueR_12 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.744444"/>
	<key name="intNodeY0" value="0.811111"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueG_12 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="2"/>
	<key name="intNodeX0" value="0.822222"/>
	<key name="intNodeY0" value="0.938889"/>
	<key name="intNodeX1" value="0.222222"/>
	<key name="intNodeY1" value="0.155556"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valueB_12 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="1"/>
	<key name="intNodeX0" value="0.688889"/>
	<key name="intNodeY0" value="0.633333"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
valuesmart_12 = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="0"/>
	<key name="intNodeX0" value="0"/>
	<key name="intNodeY0" value="0"/>
	<key name="intNodeX1" value="0"/>
	<key name="intNodeY1" value="0"/>
	<key name="intNodeX2" value="0"/>
	<key name="intNodeY2" value="0"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]
 
-- Function for lacCurves combo box
function onLacCurveChanged(v)
if( v==0 ) then
  lac:setLacData( "lacdataRGB", default_Nostal )
  lac:setLacData( "lacdataR", CurveNostalR_1 )
  lac:setLacData( "lacdataG", CurveNostalG_1 )
  lac:setLacData( "lacdataB", CurveNostalB_1 )
  lac:setLacData( "lacdataSmartBrightness", default_Nostal )
elseif( v==1) then
  lac:setLacData( "lacdataRGB", curveNostalRGB_3 )
  lac:setLacData( "lacdataR", curveNostalR_3 )
  lac:setLacData( "lacdataG", curveNostalG_3 )
  lac:setLacData( "lacdataB", curveNostalB_3 )
  lac:setLacData( "lacdataSmartBrightness", default_Nostal )
elseif( v==2) then
  lac:setLacData( "lacdataRGB", default_Nostal )
  lac:setLacData( "lacdataR", curveNostalR_2 )
  lac:setLacData( "lacdataG", curveNostalG_2 )
  lac:setLacData( "lacdataB", curveNostalB_2 )
  lac:setLacData( "lacdataSmartBrightness", default_Nostal )
elseif( v==3) then
  lac:setLacData( "lacdataRGB", default_Nostal )
  lac:setLacData( "lacdataR", curveNostalR_4 )
  lac:setLacData( "lacdataG", curveNostalG_4 )
  lac:setLacData( "lacdataB", curveNostalB_4 )
  lac:setLacData( "lacdataSmartBrightness", curveNostalSmart_4 )
 elseif( v==4 ) then
 lac:setLacData( "lacdataRGB", valueRGB_5 )
 lac:setLacData("lacdataR", valueR_5 )
 lac:setLacData("lacdataG",valueG_5 )
 lac:setLacData("lacdataB", valueB_5 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_5 ) 
 elseif( v==5 ) then
 lac:setLacData( "lacdataRGB", valueRGB_6 )
 lac:setLacData("lacdataR", valueR_6 )
 lac:setLacData("lacdataG",valueG_6 )
 lac:setLacData("lacdataB", valueB_6 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_6 )
 elseif( v==6 ) then
 lac:setLacData( "lacdataRGB", valueRGB_7 )
 lac:setLacData("lacdataR", valueR_7 )
 lac:setLacData("lacdataG",valueG_7 )
 lac:setLacData("lacdataB", valueB_7 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_7 )
 elseif( v==7 ) then
 lac:setLacData( "lacdataRGB", valueRGB_8 )
 lac:setLacData("lacdataR", valueR_8 )
 lac:setLacData("lacdataG",valueG_8 )
 lac:setLacData("lacdataB", valueB_8 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_8 ) 
 elseif( v==8 ) then
 lac:setLacData( "lacdataRGB", valueRGB_9 )
 lac:setLacData("lacdataR", valueR_9 )
 lac:setLacData("lacdataG",valueG_9 )
 lac:setLacData("lacdataB", valueB_9 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_9 ) 
 elseif( v==9 ) then
 lac:setLacData( "lacdataRGB", valueRGB_10 )
 lac:setLacData("lacdataR", valueR_10 )
 lac:setLacData("lacdataG",valueG_10 )
 lac:setLacData("lacdataB", valueB_10 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_10 ) 
 elseif( v==10 ) then
 lac:setLacData( "lacdataRGB", valueRGB_11 )
 lac:setLacData("lacdataR", valueR_11 )
 lac:setLacData("lacdataG",valueG_11 )
 lac:setLacData("lacdataB", valueB_11 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_11 )  
 elseif( v==11 ) then
 lac:setLacData( "lacdataRGB", valueRGB_12 )
 lac:setLacData("lacdataR", valueR_12 )
 lac:setLacData("lacdataG",valueG_12 )
 lac:setLacData("lacdataB", valueB_12 ) 
 lac:setLacData("lacdataSmartBrightness", valuesmart_12 )   
 end 
end

model:addCombobox("lacCurves", "onLacCurveChanged", "Film Type", "1;2;3;4;5;6;7;8;9;10;11;12" );
model:setIntParameter( "lacCurves", 1 );
model:setIntParameter( "lacCurves", 0 );

--quick fix
lac = model:getFilter(f5)
lac:setLacData( "lacdataRGB", default_Nostal )
lac:setLacData( "lacdataR", CurveNostalR_1 )
lac:setLacData( "lacdataG", CurveNostalG_1 )
lac:setLacData( "lacdataB", CurveNostalB_1 )
lac:setLacData( "lacdataSmartBrightness", default_Nostal )
  

-- Protect Hi/Sh
function protect_shadows_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectShadows", v*100)
  lsc:setFloatParameter( "boostShadows", v*100/1)
end
model:addFloatSlider("protect_shadows", 0,0,1,"protect_shadows_function", "Shadows", "")

function protect_hilights_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectHighlights", v*100)
  lsc:setFloatParameter( "boostHighlights", v*100/1)
end
model:addFloatSlider("protect_hilights", 0,0,1,"protect_hilights_function", "Highlights", "")
